/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.util.sound;

import club.sk1er.patcher.config.ConfigUtil;
import club.sk1er.vigilance.data.PropertyData;
import club.sk1er.vigilance.data.PropertyType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.PositionedSound;
import net.minecraft.client.audio.SoundEventAccessorComposite;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.text.WordUtils;

public class SoundHandler
implements IResourceManagerReloadListener {
    private final Map<ResourceLocation, PropertyData> data = new HashMap<ResourceLocation, PropertyData>();

    @SubscribeEvent
    public void onSound(PlaySoundEvent event) {
        if (event.result instanceof PositionedSound) {
            PositionedSound result = (PositionedSound)event.result;
            result.field_147662_b *= this.getVolumeMultiplier(event.result.func_147650_b());
        }
    }

    private float getVolumeMultiplier(ResourceLocation sound) {
        Object asAny;
        PropertyData propertyData = this.data.get(sound);
        if (propertyData != null && (asAny = propertyData.getAsAny()) instanceof Integer) {
            return ((Integer)asAny).floatValue() / 100.0f;
        }
        return 1.0f;
    }

    public void func_110549_a(IResourceManager resourceManager) {
        Map soundRegistry = Minecraft.func_71410_x().func_147118_V().field_147697_e.field_148764_a;
        for (Map.Entry entry : soundRegistry.entrySet()) {
            SoundEventAccessorComposite comp = (SoundEventAccessorComposite)entry.getValue();
            this.data.computeIfAbsent((ResourceLocation)entry.getKey(), location -> ConfigUtil.createAndRegisterConfig(PropertyType.SLIDER, "Sounds", WordUtils.capitalizeFully((String)comp.func_148728_d().func_147155_a()), this.getName((ResourceLocation)location), "Sound Multiplier for " + location.func_110623_a(), 100, 0, 200, o -> {}));
        }
    }

    private String getName(ResourceLocation location) {
        String resourcePath = location.func_110623_a();
        return WordUtils.capitalizeFully((String)resourcePath.replace(".", " ").replace("_", " "));
    }
}

